/*tex

Stata/MP 14.1; required packages: fre, estout, estwrite, rrreg, rrlogit

\subsection{Response rates}

tex*/

texdoc stlog
use http://repec.sowi.unibe.ch/files/wp8/ASQ-ETHBE-2011.dta
local N 19410 // gross sample
mat R = J(6,6,.)
mat coln R = "Bern:N" "Bern:RR" "Zurich:N" "Zurich:RR" "Total:N" "Total:RR"
mat rown R = "Sample" "Started" "Started2" "Completed" "Completed2" "SQ"
mat R[1,1] = 8610, 1, 10800, 1, 19410, 1
forv i = 1/3 {
    local iff: word `i' of "sample==1" "inlist(sample,2,3)" "1"
    local ii = `i'*2 - 1
    qui count if `iff'
    mat R[2,`ii'] = r(N), r(N)/R[1,`ii']
    qui count if `iff' & rl3!=.b // submitted first page with questions
    mat R[3,`ii'] = r(N), r(N)/R[1,`ii']
    qui count if `iff' & inlist(dispcode,31,32)
    mat R[4,`ii'] = r(N), r(N)/R[1,`ii']
    qui count if `iff' & rl25!=.b & rl26!=.b // submitted last page with questions
    mat R[5,`ii'] = r(N), r(N)/R[1,`ii']
    qui count if `iff' & rl10!=.b // reached sensitive questions
    mat R[6,`ii'] = r(N), r(N)/R[1,`ii']
}
// Sample:     Gross sample
// Started:    Started the survey
// Started2:   Submitted at least the first page containing questions
// Completed:  Completed questionnaire to very end
// Completed2: Completed the questionnaire to last page containing questions
mat list R
texdoc stlog close

/*tex

\subsection{Overall response time}

tex*/

texdoc stlog
su dur, detail
di r(p50)/60
su dur if dispcode==31, detail
di r(p50)/60
su dur if rl10!=.b, detail // reached sensitive questions
di r(p50)/60
su dur if rl10!=.b & dispcode==31, detail // reached sensitive questions
di r(p50)/60
texdoc stlog close

/*tex

\subsection{Selection of sample for analysis}

tex*/

texdoc stlog
// - exclude observartions who did not reach the sensitive questions intro page
// - exclude obervations that did not see the sensive questions because they 
//   did not yet have exampe and did not write a paper yet
// - exclude observations where assignment of expcond failed
// - generate language filter variable (well or very well german skills)
fre expcond
drop if expcond>=.
drop if (q17==.e & q19==.e) // one obs with valid expcond who was filtered for all items
fre expcond
qui recode expcond ///
    (1 = 1 "DQ") ///
    (4 = 2 "FRwheel") ///
    (2 = 3 "FRnumb") ///
    (5 = 4 "UQbenf") ///
    (6 = 5 "CMquest") ///
    (3 = 6 "CMnumb") ///
    , gen(expcond1)
drop expcond
rename expcond1 expcond
fre expcond
fre q4_2
gen byte language = inlist(q4_2,4,5)
fre language
fre expcond if language
gen byte nopretest = (sample!=2)
fre expcond if language & nopretest 
texdoc stlog close


/*tex

\subsection{Number of observations per item and technique}

tex*/

texdoc stlog
// SELECTION: ALL OBS
qui estpost tabstat q14 q16 q17 q18 q19, by(expcond) stat(count) ///
    columns(statistics) nototal
esttab ., main(count) unstack compress not noobs nonote nostar nonum nomti

// SELECTION: GOOD LANGUAGE SKILLS
qui estpost tabstat q14 q16 q17 q18 q19 if language, by(expcond) ///
    stat(count) columns(statistics) nototal
esttab ., main(count) unstack compress not noobs nonote nostar nonum nomti

// SELECTION: GOOD LANGUAGE SKILLS AND NO PRETEST DATA
qui estpost tabstat q14 q16 q17 q18 q19 if language & nopretest, by(expcond) ///
    stat(count) columns(statistics) nototal
esttab ., main(count) unstack compress not noobs nonote nostar nonum nomti
texdoc stlog close


/*tex

\subsection{Question sensitivity}

tex*/

texdoc stlog
preserve
keep id language nopretest q20_? q21_? q22_?
qui reshape long q20_ q21_ q22_, i(id) j(question)
lab def question ///
    1 "Copying from other students in exam" ///
    2 "Using crib notes in exam" ///
    3 "Taking drugs to enhance exam performance" ///
    4 "Including plagiarism in paper" ///
    5 "Handing in someone else's paper"
lab val question question

// desriptive norm: 100 - "How many out of 100 students have ever ...?"
qui gen descriptive = 100-q20_ if q20_<.

// personal norm: "How bad do you think is ...?" (rather bad or very bad)
qui gen personal = inlist(q21_,4,5)*100 if inlist(q21_,1,2,3,4,5)

// general norm: "How bad do most people think is ...?" (rather bad or very bad)
qui gen general = inlist(q22_,4,5)*100 if inlist(q22_,1,2,3,4,5)

// SELECTION: ALL OBS
qui estpost tabstat descriptive personal general ///
    , by(question) nototal
esttab, cell((descriptive(f(0)) personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti
qui estpost tabstat descriptive personal general ///
    , by(question) s(count) nototal
esttab, cell((descriptive personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti

// SELECTION: GOOD LANGUAGE SKILLS
qui estpost tabstat descriptive personal general if language ///
    , by(question) nototal
esttab, cell((descriptive(f(0)) personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti
qui estpost tabstat descriptive personal general if language ///
    , by(question) s(count) nototal
esttab, cell((descriptive personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti

// SELECTION: GOOD LANGUAGE SKILLS AND NO PRETEST DATA
qui estpost tabstat descriptive personal general if language & nopretest ///
    , by(question) nototal
esttab, cell((descriptive(f(0)) personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti
qui estpost tabstat descriptive personal general if language & nopretest ///
    , by(question) s(count) nototal
esttab, cell((descriptive personal general)) ///
    varlab(`e(labels)') varwidth(35) noobs nonum nomti
restore
texdoc stlog close

/*tex

\subsection{Prevalence estimates}

tex*/

texdoc stlog
capt prog drop nlrrreg
program nlrrreg, rclass // nonlinear randomized response regression
    version 13.1
    syntax varlist(min=2) [aw fw iw] if
    gettoken lhs rhs : varlist
    local xb
    local plus
    foreach v in `rhs' {
        local xb `xb' `plus' {`v'}*`v'
        local plus "+"
    }
    return local eq "`lhs' = (1-`lhs'_pyes-`lhs'_pno)*((2*`lhs'_pcm-1)*(`xb')-`lhs'_pcm+1)+`lhs'_pyes"
    return local title "`lhs' = (1 - pyes - pno)*((2*pcm - 1)*{xb} - pcm + 1) + pyes"
end
est clear
forv i = 0/2 {
    preserve
    if `i'==1 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS"
        keep if language
    }
    else if `i'==2 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS AND NO PRETEST DATA"
        keep if language & nopretest
    }
    else di _n as res "==> SELECTION: ALL OBS"
    // prevalence by implementation
    gen byte DQ      = expcond==1
    gen byte FRwheel = expcond==2
    gen byte FRnumb  = expcond==3
    gen byte UQbenf  = expcond==4
    gen byte CMquest  = expcond==5
    gen byte CMnumb   = expcond==6
    foreach v in q14 q16 q17 q18 q19 {
        di _n as res `"==> `v': `:var lab `v''"'
        // least-squares
        rrreg `v' DQ FRwheel FRnumb UQbenf CMquest CMnumb ///
            , nocons hc2 pyes(`v'_pyes) pno(`v'_pno) pwarner(`v'_pcm)
        est sto `v'
        nlcom (FRwheel: _b[FRwheel]-_b[DQ]) (FRnumb:_b[FRnumb]-_b[DQ]) ///
              (UQbenf:_b[UQbenf]-_b[DQ]) (CMquest:_b[CMquest]-_b[DQ]) ///
              (CMnumb:_b[CMnumb]-_b[DQ]), post
        est sto `v'_d
        // nonlinear least-squares
        nl rrreg: `v' DQ FRwheel FRnumb UQbenf CMquest CMnumb, vce(robust)
        est sto `v'_nl
        nlcom (FRwheel: _b[/FRwheel]-_b[/DQ]) (FRnumb:_b[/FRnumb]-_b[/DQ]) ///
              (UQbenf:_b[/UQbenf]-_b[/DQ]) (CMquest:_b[/CMquest]-_b[/DQ]) ///
              (CMnumb:_b[/CMnumb]-_b[/DQ]), post
        est sto `v'_nl_d
        // maximum likelihood
        rrlogit `v' DQ FRwheel FRnumb UQbenf CMquest CMnumb ///
            , nocons robust nolog pyes(`v'_pyes) pno(`v'_pno) pwarner(`v'_pcm)
        est sto `v'_ml
        nlcom (FRwheel: _b[FRwheel]-_b[DQ]) (FRnumb:_b[FRnumb]-_b[DQ]) ///
              (UQbenf:_b[UQbenf]-_b[DQ]) (CMquest:_b[CMquest]-_b[DQ]) ///
              (CMnumb:_b[CMnumb]-_b[DQ]), post
        est sto `v'_ml_d
    }
    qui estwrite * using log/main/detailed`i', replace
    est clear
    restore
}
texdoc stlog close

/*tex

\subsection{Quality criteria}

Breakoff, Item-Nonresponse, Answering time, Trust, Disclosure Risk, 
Protection, Understanding, Compliance; 
note: sample already restricted to the ones who reached the sensitive 
questions (i.e. obs with valid expcond)

tex*/

texdoc stlog
// - breakoff
gen byte breakoff = (rl25==.b | rl26==.b) // did not reach end of questionnaire
                               // (i.e. did not submit last page with questions)
fre breakoff
// - item nonresponse (proportion of items not answered)
assert !((q14==.e | q16==.e | q17==.e) & (q18==.e | q19==.e))
assert (q14==.e & q16==.e & q17==.e) if (q14==.e | q16==.e | q17==.e) 
assert (q18==.e & q19==.e) if (q18==.e | q19==.e)
gen nonresp = 0
gen byte items = 0
foreach v in q14 q16 q17 q18 q19 {
    qui replace nonresp = nonresp + 1 if inlist(`v', .a, .b)
    qui replace items = items + 1 if `v'<=.b
}
fre items
fre nonresp
replace nonresp = nonresp / items
drop items
fre nonresp
// - total time to answer sensitive question block (only respondents who
//   completed the block)
gen time = 0
foreach v of var rl11-rl19 {
    qui replace time = time + `v' if `v'!=.c // => missing if breakoff 
}
su time, d
gen time2 = 0
foreach v of var rl14 rl16-rl19 { // only the actual questions without instruction pages
    qui replace time2 = time2 + `v' if `v'!=.c // => missing if breakoff 
}
su time2, d
// - trust in anonymity (q25_1)
fre q25_1
gen byte trust = inlist(q25_1,4,5) if inlist(q25_1,1,2,3,4,5)
fre trust
// - risk of disclosure
fre q25_2
gen byte risk = inlist(q25_2,4,5) if inlist(q25_2,1,2,3,4,5)
fre risk
// - cumbersome to use
fre q26_1
gen byte cumbersome = inlist(q26_1,4,5) if inlist(q26_1,1,2,3,4,5) & expcond!=1
fre cumbersome
// - applied technique correctly
fre q26_2
gen byte correct = inlist(q26_2,4,5) if inlist(q26_2,1,2,3,4,5) & expcond!=1
fre correct
// - does technique protect?
fre q26_3
gen byte tprotect = inlist(q26_3,4,5) if inlist(q26_3,1,2,3,4,5) & expcond!=1
fre tprotect
// - does technique make sense?
fre q26_4
gen byte sense = inlist(q26_4,4,5) if inlist(q26_4,1,2,3,4,5) & expcond!=1
fre sense
// - do you understand?
fre q26_5
gen byte understand = inlist(q26_5,4,5) if inlist(q26_5,1,2,3,4,5) & expcond!=1
fre understand

capt prog drop mymedian
program mymedian, eclass
    syntax varname [if] [in], over(varname) [ level(passthru) * ]
    marksample touse
    markout `touse' `over'
    qui count if `touse'
    local N = r(N)
    tempname b se _N V df
    local coln
    qui levelsof `over'
    foreach l in `r(levels)' {
        local coln `"`coln' `"`: lab (`over') `l''"'"'
        qui qreg `varlist' if `touse' & (`over'==`l'), quantile(.5) `options'
        mat `b' = nullmat(`b'), _b[_cons]
        mat `se' = nullmat(`se'), _se[_cons]
        mat `df' = nullmat(`df'), e(df_r)
        mat `_N' = nullmat(`_N'), e(N)
    }
    mat coln `b' = `coln'
    mat coln `se' = `coln'
    mat coln `df' = `coln'
    mat coln `_N' = `coln'
    mat `V' = diag(vecdiag(`se'' * `se'))
    eret post `b' `V', esample(`touse') obs(`N')
    eret local cmd "mymedian"
    eret local depvar "`varlist'"
    eret local over   "`over'"
    eret matrix _N = `_N'
    eret matrix df = `df'
    _coef_table_header
    eret di
end
local d (dFRwheel: _b[FRwheel]-_b[DQ]) (dFRnumb: _b[FRnumb]-_b[DQ]) ///
        (dUQbenf: _b[UQbenf]-_b[DQ]) (dCMquest: _b[CMquest]-_b[DQ]) ///
        (dCMnumb: _b[CMnumb]-_b[DQ])
forv i = 0/2 {
    preserve
    if `i'==1 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS"
        keep if language
    }
    else if `i'==2 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS AND NO PRETEST DATA"
        keep if language & nopretest
    }
    else di _n as res "==> SELECTION: ALL OBS"
    mean breakoff, over(expcond) citype(logit)
    est sto breakoff
    nlcom `d'
    mean nonresp, over(expcond) citype(logit)
    est sto nonresp
    nlcom `d'
    mymedian time, over(expcond)
    est sto time
    nlcom `d'
    mymedian time2, over(expcond)
    est sto time2
    nlcom `d'
    mean trust, over(expcond) citype(logit)
    est sto trust
    nlcom `d'
    mean risk, over(expcond) citype(logit)
    est sto risk
    nlcom `d'
    mean cumbersome, over(expcond) citype(logit)
    est sto cumbersome
    mean correct, over(expcond) citype(logit)
    est sto correct
    mean tprotect, over(expcond) citype(logit)
    est sto tprotect
    mean sense, over(expcond) citype(logit)
    est sto sense
    mean understand, over(expcond) citype(logit)
    est sto understand
    qui estwrite * using log/main/eval`i', replace
    restore
}

pwcorr trust risk cumbersome correct tprotect sense understand, sig bonferroni
pwcorr trust risk cumbersome correct tprotect sense understand ///
    if language, sig bonferroni
pwcorr trust risk cumbersome correct tprotect sense understand ///
    if language & nopretest, sig bonferroni
texdoc stlog close


/*tex

\subsection{Correlation between protection level (design parameters) and trust}

tex*/

texdoc stlog
generate byte highprotection = (protect==1) if protect<.
forv i = 0/2 {
    preserve
    if `i'==1 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS"
        keep if language
    }
    else if `i'==2 {
        di _n as res "==> SELECTION: GOOD LANGUAGE SKILLS AND NO PRETEST DATA"
        keep if language & nopretest
    }
    else di _n as res "==> SELECTION: ALL OBS"
    qui eststo Total: estpost correlate highprotection trust risk tprotect sense
    forv i = 2/6 {
        qui eststo t`i', ti(`: lab (expcond) `i''): ///
            estpost correlate highprotection trust risk tprotect sense ///
            if expcond==`i'
    }
    esttab Total t?, mti nonum p nostar noobs
    restore
}
texdoc stlog close

